<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($career ?? ''  && $career->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="form-group col-lg-12">
                <label><?php echo e(meta('service_id', $lang) ?? __('careers.service_id')); ?> </label>
                <select name="service_id" class="form-control <?php echo e($errors->has('service_id') ? 'is-invalid' : ''); ?>">
                    <?php if(count($services)): ?>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(old('service_id', $career->service_id ?? null) == $service->service_id ? 'selected' : ''); ?> value="<?php echo e($service->service_id); ?>"><?php echo e($service->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('name', $language->local) ?? __('careers.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('careers.name')); ?>" value='<?php echo e(old("name_{$language->local}", $career[$language->local]->name ?? "")); ?>'/>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('description', $language->local) ?? __('careers.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="description_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('careers.description')); ?>"><?php echo e(old("description_{$language->local}", $career[$language->local]->description ?? "")); ?></textarea>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <div class="form-group col-lg-12 image_container">
                <label><?php echo e(meta('image', $lang) ?? __('careers.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $career->image ?? "")); ?>"/>

                <div class="photos main_photo <?php echo e(old('image', $career->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $career->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button <?php echo e(old('image', $career->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
            </div>
            

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/careers/form.blade.php ENDPATH**/ ?>