<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($websiteCategory ?? ''  && $websiteCategory->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('name', $lang) ?? __('websiteCategories.name')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('name_'.$lang) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($lang); ?>" placeholder="<?php echo e(meta('name', $lang) ?? __('websiteCategories.name')); ?>" value='<?php echo e(old("name_".$lang, $websiteCategory ?? '' ? descriptions($websiteCategory)->name ?? null : "")); ?>'/>
        </div>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('slug', $lang) ?? __('websiteCategories.slug')); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('slug_'.$lang) ? 'is-invalid' : ''); ?>" name="slug_<?php echo e($lang); ?>" placeholder="<?php echo e(meta('slug', $lang) ?? __('websiteCategories.slug')); ?>" value='<?php echo e(old("slug_".$lang, $websiteCategory ?? '' ? descriptions($websiteCategory)->slug ?? null : "")); ?>'/>
        </div>
        <div class="border-item photos col-md-12">
            <div class="row">
                <?php if($websiteCategory ?? false): ?>
                    <?php $__currentLoopData = $websiteCategory['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6">
                            <div class="items">
                                <div class="img">
                                    <a href="<?php echo e(asset($photo->image ?? '')); ?>" data-fancybox="gallery"><img src="<?php echo e(asset($photo->image ?? '')); ?>" alt=""></a>
                                </div>
                                <div class="info">
                                    <div class="img-title">
                                        <input type="text" name="image_title_<?php echo e($lang); ?>[]"  placeholder="<?php echo e(meta('image_title', $lang) ?? __('websiteCategories.title')); ?>" value="<?php echo e(descriptions($photo)->title ?? ""); ?>">
                                        <input type="text" name="image_url[]"  placeholder="<?php echo e(meta('image_url', $lang) ?? __('websiteCategories.url')); ?>" value="<?php echo e($photo->url ?? ""); ?>">
                                        <input type="hidden" name="images[]" value="<?php echo e($photo->image ?? ""); ?>">
                                        <span class="preview"> </span>
                                    </div>
                                </div>
                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <div class="text-center">
                <input id="website_gallery_photo_thumbnail" class="website_gallery_photo_thumbnail" type="hidden"/>
                <div class="clearfix"></div>
                <span id="add">
                <a id="lfm" data-cache="website_gallery_photos" data-title="true" data-url="true" data-width="col-md-6" data-input=".website_gallery_photo_thumbnail" data-preview=".website_gallery_photo_thumbnail" data-show="" data-hide="" class="lfm add">
                    <?php echo e(meta('new_item', $lang ?? 'Add New Item')); ?>

                </a>
            </span>
            </div>
        </div>

        <div class="text-center mt-5 col-12">
            <button class="butn"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
        <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>

    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imageTitle = "<?php echo e(meta('image_title', $lang) ?? null); ?>",
            imageUrl = "<?php echo e(meta('image_url', $lang) ?? null); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/website_galleries.js')); ?>"></script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\cms\resources\views/admin/website_categories/form.blade.php ENDPATH**/ ?>