<footer class="footer section pb-0">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-lg-2">
                <div class="content">
                    <img src="<?php echo e(asset('assets/web/images/logo.svg')); ?>" alt="" class="logo mb-4"/>
                    <p class="det"><?php echo e($settings['site_phone']); ?></p>
                    <p class="det"><?php echo e($settings['site_address_'.$lang]); ?></p>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="content">
                    <p class="p"><?php echo pages(21)->description; ?></p>
                    <div class="social_links mt-3">
                        <?php if($settings['facebook'] ?? null): ?>
                            <a target="_blank" href="<?php echo e($settings['facebook']); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if($settings['instagram'] ?? null): ?>
                            <a target="_blank" href="<?php echo e($settings['instagram']); ?>"><i class="fa-brands fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if($settings['linkedin'] ?? null): ?>
                            <a target="_blank" href="<?php echo e($settings['linkedin']); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                        <?php endif; ?>
                        <?php if($settings['snapchat'] ?? null): ?>
                            <a target="_blank" href="<?php echo e($settings['snapchat']); ?>"><i class="fa-brands fa-snapchat"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-2">
                <div class="content">
                    <h5 class="title color-dark fw-bold mb-4">Direct Links</h5>
                    <div class="links">
                        <?php if(count(specializations())): ?>
                            <?php $__currentLoopData = specializations(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('service.show', $specialization->id)); ?>"><?php echo e($specialization->name); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <p class="copyright_p mb-0 py-3 mt-4 text-center">
            © Copyright <?php echo e(date('Y')); ?> <b class="color-dark"><?php echo e(__('main.copy_right_first_word')); ?></b> <?php echo e(__('main.copy_right_second_word')); ?>

        </p>
    </div>
</footer>
<!-- Start modal -->
<?php if($settings['show_start_pop_up']): ?>
    <div class="modal startingModal" tabindex="1" id="startingModal">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-body">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <img src="<?php echo e(asset(pages(22)->image)); ?>" alt="" class="sec-img"/>
                        </div>
                        <div class="col-lg-6">
                            <div class="text-box py-3">
                                <h2 class="title fw-bold color-dark mb-3"><?php echo e(pages(22)->title); ?></h2>
                                <p class="det"><?php echo e(pages(22)->description); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?><!--Scroll to top button-->
<div class="progress-wrap ">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 220.587;"></path></svg>
</div>
<?php /**PATH C:\wamp64\www\procare\resources\views/web/layouts/footer.blade.php ENDPATH**/ ?>