<?php $__env->startSection('content'); ?>
<form>
<div class="side-title">
    <div class="row">
        <div class="col-lg-6">
            <h3><?php echo e($title); ?></h3>
        </div>
        <div class="col-lg-6 valign">
            <div class="edit-buttons text-right w-100">
                <a href="<?php echo e(route ('careerApplications.destroyAll')); ?>" data-method="delete" class="butn statusButns status_1 tableAction btn disabled bg-warning"> <span><?php echo e(__('dashboard.sendToTrash')); ?></span></a>
                <a href="#" class="butn statusButns status_1 showArchive bg-primary"> <span> <?php echo e(__('dashboard.displayTrash')); ?> </span></a>

                <a href="<?php echo e(route ('careerApplications.destroyAll')); ?>" data-method="delete" class="butn statusButns status_0 tableAction btn disabled bg-danger force"> <span> <?php echo e(__('dashboard.delete')); ?> </span></a>
                <a href="<?php echo e(route ('careerApplications.restoreAll')); ?>" data-method="put" class="butn statusButns status_0 tableAction btn disabled bg-info"> <span> <?php echo e(__('dashboard.restore')); ?> </span></a>
                <a href="#" class="butn statusButns status_0 showActive bg-primary"> <span> <?php echo e(__('dashboard.displayActive')); ?> </span></a>
            </div>
        </div>
    </div>
</div>

<!-- ------------ data table ------------- -->
<table class="table table-hover table-bordered">
    <thead>
        <tr>
            <th scope="col">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" id="selectall" name="example1">
                    <label class="custom-control-label" for="selectall"> </label>
                </div>
            </th>
            <th scope="col"><?php echo e(__('careerApplications.name')); ?></th>
            <th scope="col"><?php echo e(__('careerApplications.career_id')); ?></th>
            <th scope="col"><?php echo e(__('careerApplications.service_id')); ?></th>

            <th scope="col" colspan="2"><?php echo e(__('careerApplications.submission_date')); ?></th>
            <th scope="col"><?php echo e(__('dashboard.processes')); ?></th>
        </tr>
    </thead>

    <tbody class="response">
        <tr class="search_filter_form">
            <th scope="row"></th>
            <th scope="row">
                <input type="text" name="name" value="<?php echo e($request->name ?? ''); ?>" class="form-control" placeholder="">
            </th>
            <th scope="row">
                <select name="career_id" class="form-control">
                    <option value=""><?php echo e(__('careerApplications.career_id')); ?></option>
                    <?php if(count($careers)): ?>
                        <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($career->id); ?>"><?php echo e($career->currentDescription->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </th>

            <th scope="row">
                <select name="service_id" class="form-control">
                    <option value=""><?php echo e(__('careerApplications.service_id')); ?></option>
                    <?php if(count($services)): ?>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($service->id); ?>"><?php echo e($service->currentDescription->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </th>



            <td>
                <input type="date" placeholder="<?php echo e(__('dashboard.date_from')); ?>" name="submission_date_from" value="<?php echo e($request->submission_date_from ?? ''); ?>" class=" form-control">
            </td>
            <td>
                <input type="date" placeholder="<?php echo e(__('dashboard.date_to')); ?>" name="submission_date_to" value="<?php echo e($request->submission_date_to ?? ''); ?>" class=" form-control">
            </td>
            <th scope="col"><button type="button" class="butn color small search"><span><i class="fas fa-search"></i></span></button></th>
        </tr>
    </tbody>


</table>
<!-- ------------ sidemenu links ------------- -->
</form>
<?php $__env->stopSection(); ?>



<script>
/**
 * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
 */
var dataTable={
    route: '<?php echo e(route("careerApplications.grid")); ?>'
}
</script>
<?php $__env->startSection('inner_js'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/career_applications/index.blade.php ENDPATH**/ ?>