<div class="border-item">
    <form class="form-row site_settings_form" method="post" action="<?php echo e($settingsAction); ?>" enctype="multipart/form-data">
        <?php if($settings): ?>
            <input type="hidden" name="update" value="true">
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <?php if(auth()->user()->role == 'super_admin'): ?>
            <div class="col-md-12">
                <div class="card mb-5">
                    <div class="card-header">
                        <h4><?php echo e(__('settings.disable_dashboard')); ?></h4>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <i class="fas fa-globe"></i> <b><?php echo e(meta('website_disable', getCurrentLocale()) ?? 'Website Disabled'); ?></b>
                            <label class="switch ">
                                <input <?php echo e($settings->website_disable == 1 ? 'checked' : ''); ?> type="checkbox" class="success" name="website_disable" value="1">
                                <span class="slider"></span>
                            </label>
                        </li>
                        <li class="list-group-item">
                            <i class="fas fa-chart-line"></i> <b> <?php echo e(meta('dashboard_disable', getCurrentLocale()) ?? 'Dashboard Disabled'); ?></b>
                            <label class="switch ">
                                <input <?php echo e($settings->dashboard_disable == 1 ? 'checked' : ''); ?> type="checkbox" class="success" name="dashboard_disable" value="1">
                                <span class="slider"></span>
                            </label>
                        </li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('website_name', $language->local) ?? __('articles.website_name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('website_name_'.$language->local) ? 'is-invalid' : ''); ?>" name="website_name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('website_name', $language->local) ?? __('articles.website_name')); ?>" value='<?php echo e(old("website_name_{$language->local}", $settings->{'website_name_'.$language->local} ?? "")); ?>'/>
            </div>





            <div class="form-group col-lg-6">
                <label><?php echo e(meta('Keywords', $language->local) ?? __('articles.Keywords')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('Keywords_'.$language->local) ? 'is-invalid' : ''); ?>" name="Keywords_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('Keywords', $language->local) ?? __('articles.Keywords')); ?>" value='<?php echo e(old("Keywords_{$language->local}", $settings->{'keywords_'.$language->local} ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('meta_description', $language->local) ?? __('articles.meta_description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('meta_description_'.$language->local) ? 'is-invalid' : ''); ?>" name="meta_description_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('meta_description', $language->local) ?? __('articles.meta_description')); ?>" value='<?php echo e(old("meta_description_{$language->local}", $settings->{'meta_description_'.$language->local} ?? "")); ?>'/>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('site_email', getCurrentLocale()) ?? __('settings.site_email')); ?></label>
            <input type="email" class="form-control <?php echo e($errors->has('site_email') ? 'is-invalid' : ''); ?>" name="site_email" placeholder="<?php echo e(meta('site_email', getCurrentLocale()) ?? __('settings.site_email')); ?>" value='<?php echo e(old("site_email", $settings->site_email ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('site_phone', getCurrentLocale()) ?? __('settings.site_phone')); ?></label>
            <input type="tel" class="form-control <?php echo e($errors->has('site_phone') ? 'is-invalid' : ''); ?>" name="site_phone" placeholder="<?php echo e(meta('site_phone', getCurrentLocale()) ?? __('settings.site_phone')); ?>" value='<?php echo e(old("site_phone", $settings->site_phone ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_driver', getCurrentLocale()) ?? __('settings.mail_driver')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('mail_driver') ? 'is-invalid' : ''); ?>" name="mail_driver" placeholder="<?php echo e(meta('mail_driver', getCurrentLocale()) ?? __('settings.mail_driver')); ?>" value='<?php echo e(old("mail_driver", $settings->mail_driver ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_host', getCurrentLocale()) ?? __('settings.mail_host')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('mail_host') ? 'is-invalid' : ''); ?>" name="mail_host" placeholder="<?php echo e(meta('mail_host', getCurrentLocale()) ?? __('settings.mail_host')); ?>" value='<?php echo e(old("mail_host", $settings->mail_host ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_port', getCurrentLocale()) ?? __('settings.mail_port')); ?></label>
            <input type="number" class="form-control <?php echo e($errors->has('mail_port') ? 'is-invalid' : ''); ?>" name="mail_port" placeholder="<?php echo e(meta('mail_port', getCurrentLocale()) ?? __('settings.mail_port')); ?>" value='<?php echo e(old("mail_port", $settings->mail_port ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_username', getCurrentLocale()) ?? __('settings.mail_username')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('mail_username') ? 'is-invalid' : ''); ?>" name="mail_username" placeholder="<?php echo e(meta('mail_username', getCurrentLocale()) ?? __('settings.mail_username')); ?>" value='<?php echo e(old("mail_username", $settings->mail_username ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_password', getCurrentLocale()) ?? __('settings.mail_password')); ?></label>
            <input type="password" class="form-control <?php echo e($errors->has('mail_password') ? 'is-invalid' : ''); ?>" name="mail_password" placeholder="<?php echo e(meta('mail_password', getCurrentLocale()) ?? __('settings.mail_password')); ?>" value='<?php echo e(old("mail_password", $settings->mail_password ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_encryption', getCurrentLocale()) ?? __('settings.mail_encryption')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('mail_encryption') ? 'is-invalid' : ''); ?>" name="mail_encryption" placeholder="<?php echo e(meta('mail_encryption', getCurrentLocale()) ?? __('settings.mail_encryption')); ?>" value='<?php echo e(old("mail_encryption", $settings->mail_encryption ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_from_address', getCurrentLocale()) ?? __('settings.mail_from_address')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('mail_from_address') ? 'is-invalid' : ''); ?>" name="mail_from_address" placeholder="<?php echo e(meta('mail_from_address', getCurrentLocale()) ?? __('settings.mail_from_address')); ?>" value='<?php echo e(old("mail_from_address", $settings->mail_from_address ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('mail_from_name', getCurrentLocale()) ?? __('settings.mail_from_name')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('mail_from_name') ? 'is-invalid' : ''); ?>" name="mail_from_name" placeholder="<?php echo e(meta('mail_from_name', getCurrentLocale()) ?? __('settings.mail_from_name')); ?>" value='<?php echo e(old("mail_from_name", $settings->mail_from_name ?? "")); ?>'/>
        </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('facebook', getCurrentLocale()) ?? __('settings.facebook')); ?></label>
                <input type="text" class="form-control <?php echo e($errors->has('facebook') ? 'is-invalid' : ''); ?>" name="facebook" placeholder="<?php echo e(meta('facebook', getCurrentLocale()) ?? __('settings.facebook')); ?>" value='<?php echo e(old("facebook", $settings->facebook ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('tiktok', getCurrentLocale()) ?? __('settings.tiktok')); ?></label>
                <input type="text" class="form-control <?php echo e($errors->has('tiktok') ? 'is-invalid' : ''); ?>" name="tiktok" placeholder="<?php echo e(meta('tiktok', getCurrentLocale()) ?? __('settings.tiktok')); ?>" value='<?php echo e(old("tiktok", $settings->tiktok ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('instagram', getCurrentLocale()) ?? __('settings.instagram')); ?></label>
                <input type="text" class="form-control <?php echo e($errors->has('instagram') ? 'is-invalid' : ''); ?>" name="instagram" placeholder="<?php echo e(meta('instagram', getCurrentLocale()) ?? __('settings.instagram')); ?>" value='<?php echo e(old("instagram", $settings->instagram ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('snapchat', getCurrentLocale()) ?? __('settings.snapchat')); ?></label>
                <input type="text" class="form-control <?php echo e($errors->has('snapchat') ? 'is-invalid' : ''); ?>" name="snapchat" placeholder="<?php echo e(meta('snapchat', getCurrentLocale()) ?? __('settings.snapchat')); ?>" value='<?php echo e(old("snapchat", $settings->snapchat ?? "")); ?>'/>
            </div>
            <div class="form-group col">
                <label><?php echo e(meta('career_link', getCurrentLocale()) ?? __('settings.career_link')); ?></label>
                <input type="text" class="form-control <?php echo e($errors->has('career_link') ? 'is-invalid' : ''); ?>" name="career_link" placeholder="<?php echo e(meta('career_link', getCurrentLocale()) ?? __('settings.career_link')); ?>" value='<?php echo e(old("career_link", $settings->career_link ?? "")); ?>'/>
            </div>

        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('website_logo', getCurrentLocale()) ?? __('settings.website_logo')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="website_logo" value="<?php echo e(old("website_logo", $settings->website_logo ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('website_logo', $settings->website_logo ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('website_logo', $settings->website_logo ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('website_logo', $settings->website_logo ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
            </span>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn site_settings_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>
<?php /**PATH C:\wamp64\www\nesma_cnc\resources\views/admin/settings/site_settings.blade.php ENDPATH**/ ?>