<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_slider_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="<?php echo e(auth()->id()); ?>">
        <?php if($slider ?? ''  && $slider->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>











        <?php if(!in_array(($slider->id ?? null), [5,6,7,8])): ?>
            <div class="form-group col-md-12">
                <label><?php echo e(meta('show_in', $lang) ?? __('sliders.show_in')); ?> </label>
                <select name="show_in" class="form-control">
                    <option value=""><?php echo e(meta('show_in', $lang) ?? __('sliders.show_in')); ?></option>
                    <option <?php echo e(old('show_in', $slider->show_in ?? null) == 'home' ? 'selected' : ''); ?> value="home"><?php echo e(__('sliders.home')); ?></option>
                    <option <?php echo e(old('show_in', $slider->show_in ?? null) == 'contact' ? 'selected' : ''); ?> value="contact"><?php echo e(__('sliders.contact')); ?></option>
                    
                    
                </select>
            </div>
        <?php endif; ?>




        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('title', $language->local) ?? __('sliders.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('sliders.title')); ?>" value='<?php echo e(old("title_{$language->local}", $slider[$language->local]->title ?? "")); ?>'/>
        </div>

            <?php if(!in_array(($slider->id ?? null), [6,8])): ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('description', $language->local) ?? __('sliders.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="description_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('sliders.description')); ?>"><?php echo e(old("description_{$language->local}", $slider[$language->local]->description ?? "")); ?></textarea>
                </div>
            <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('image', $lang) ?? __('sliders.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $slider->image ?? "")); ?>"/>

            <div class="photos image_main_photo <?php echo e(old('image', $slider->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-12">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".image_pick_button">
                                <img src="<?php echo e(asset(old('image', $slider->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".image_main_photo" data-show=".image_pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn image_pick_button <?php echo e(old('image', $slider->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".image_main_photo" data-hide=".image_pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
            </span>
        </div>
        


        <div class="text-center mt-5 col-12">
            <button class="butn add_slider_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        var route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>";
        var url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            inputName = '';
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_slider_button', '.add_slider_form')
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\nesma_cnc\resources\views/admin/sliders/form.blade.php ENDPATH**/ ?>