<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_address_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($address ?? ''  && $address->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('email', $lang) ?? __('addresses.email')); ?> </label>
            <input type="email" class="form-control" name="email" placeholder="<?php echo e(meta('email', $lang) ?? __('addresses.email')); ?>" value='<?php echo e($address->email ?? ""); ?>'/>
        </div>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('phone', $lang) ?? __('addresses.phone')); ?> </label>
            <input type="tel" class="form-control" name="phone" placeholder="<?php echo e(meta('phone', $lang) ?? __('addresses.phone')); ?>" value='<?php echo e($address->phone ?? ""); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('map_url', $lang) ?? __('addresses.map_url')); ?> </label>
            <input type="text" class="form-control" name="map_url" placeholder="<?php echo e(meta('map_url', $lang) ?? __('addresses.map_url')); ?>" value='<?php echo e($address->map_url ?? ""); ?>'/>
        </div>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('name', $language->local) ?? __('addresses.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('addresses.name')); ?>" value='<?php echo e(old("name_{$language->local}", $address[$language->local]->name ?? "")); ?>'/>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="text-center mt-5 col-12">
            <button class="butn add_address_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <script>
        sendAjax('.add_address_button', '.add_address_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\nesma_cnc\resources\views/admin/addresses/form.blade.php ENDPATH**/ ?>