<div class="navs-container">
    <!--Start main-nav-->
    <nav class="navbar navbar-expand-lg navbar-light">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('home'), [], true)); ?>">
                <img src="<?php echo e(asset('assets/web/images/logo.svg')); ?>" alt="" class="logo"/>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <div class="dropdown ms-5 search_dropdown">
                    <button class="search_butn" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="<?php echo e(asset('assets/web/images/icons/search.svg')); ?>" alt="" class="search_icon filterPrimary"/>
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                        <form>
                            <div class="form-group">
                                <input class="form-control" placeholder="Search..."/>
                                <button class="search_submit_butn">
                                    <img src="<?php echo e(asset('assets/web/images/icons/search.svg')); ?>" alt="" class="icon icon-15"/>
                                </button>
                            </div>
                        </form>
                    </ul>
                </div>
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('home'))); ?>" aria-current="page" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('home'), [], true)); ?>"><?php echo e(__('main.home')); ?></a>
                    </li>
                    
                    <li class="nav-item dropDown megaMenu col3">
                        <a class="nav-link dropLink <?php echo e(isActive([
                         route('page.show', [7, 'chairman-message']),
                         route('page.show', [12, 'quality-department']),
                         route('page.show', [13, 'accreditation']),
                         route('page.show', [14, 'ceo-message']),
                         route('page.show', ['mvv', 'mission-vision-values']),
                        ])); ?>" href="#">
                            <?php echo e(__('main.about')); ?>

                            <small class="icon"><i class="bi bi-chevron-down me-1"></i></small>
                        </a>
                        <ul class="dropDownMenu">
                            <li class="dropdown-items">
                                <a href="#" class="menuLink"><?php echo e(__('main.about')); ?></a>
                                <ul class="subDropDown">
                                    <li>
                                        <a href="<?php echo e(route('page.show', ['mvv', 'mission-vision-values'])); ?>" class="subLink">
                                            <?php echo e(__('main.mvv')); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [7, 'chairman-message'])); ?>" class="subLink">
                                            <?php echo e(pages(7)->page_title); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [14, 'ceo-message'])); ?>" class="subLink">
                                            <?php echo e(pages(14)->page_title); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [13, 'accreditation'])); ?>" class="subLink">
                                            <?php echo e(pages(13)->page_title); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [12, 'quality-department'])); ?>" class="subLink">
                                            <?php echo e(pages(12)->page_title); ?>

                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropDown megaMenu col3">
                        <a class="nav-link dropLink <?php echo e(isActive([
                         route('page.show', [8, 'patient-information']),
                         route('page.show', [9, 'patients-services']),
                         route('page.show', [10, 'InPatient']),
                         route('page.show', [11, 'nursing']),
                         route('service.index'),
                         ])); ?>" href="#">
                            <?php echo e(__('main.clinics_services')); ?>

                            <small class="icon"><i class="bi bi-chevron-down me-1"></i></small>
                        </a>
                        <ul class="dropDownMenu">
                            <li class="dropdown-items">
                                <a href="#" class="menuLink"><?php echo e(__('main.clinics_services')); ?></a>
                                <ul class="subDropDown">
                                    <li>
                                        <a href="<?php echo e(route('service.index')); ?>" class="subLink">
                                            <?php echo e(__('services.head')); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [9, 'patients-services'])); ?>" class="subLink">
                                            <?php echo e(pages(9)->page_title); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [10, 'InPatient'])); ?>" class="subLink">
                                            <?php echo e(pages(10)->page_title); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [11, 'nursing'])); ?>" class="subLink">
                                            <?php echo e(pages(11)->page_title); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('page.show', [8,'patient-information'])); ?>" class="subLink">
                                            <?php echo e(pages(8)->page_title); ?>

                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('doctor.index'))); ?>" href="<?php echo e(route('doctor.index')); ?>"><?php echo e(__('doctors.head')); ?></a>
                    </li>
                    
                    <li class="nav-item dropDown megaMenu col3">
                        <a class="nav-link dropLink <?php echo e(isActive([
                        route('jobs.index'),
                        route('news.index'),
                        route('conference.index')
                        ])); ?>" href="#">
                            <?php echo e(__('main.e_services')); ?>

                            <small class="icon"><i class="bi bi-chevron-down me-1"></i></small>
                        </a>
                        <ul class="dropDownMenu">
                            <li class="dropdown-items">
                                <a href="#" class="menuLink"><?php echo e(__('main.e_services')); ?></a>
                                <ul class="subDropDown">
                                    <li>
                                        <a href="<?php echo e(route('jobs.index')); ?>" class="subLink">
                                            <?php echo e(__('careers.head')); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('news.index')); ?>" class="subLink">
                                            <?php echo e(__('articles.head')); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('conference.index')); ?>" class="subLink">
                                            <?php echo e(__('conferences.head')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('gallery.index'))); ?>" href="<?php echo e(route('gallery.index')); ?>"><?php echo e(__('galleries.head')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('contact.index'))); ?>" href="<?php echo e(route('contact.index')); ?>"><?php echo e(__('main.contact_us')); ?></a>
                    </li>
                </ul>
                <div class="nav_r d-flex align-items-center">
                    <img src="<?php echo e(asset('assets/web/images/Jci_logo.svg')); ?>" alt="" class="nav_logo"/>
                    <img src="<?php echo e(asset('assets/web/images/cbahi_logo.svg')); ?>" alt="" class="nav_logo"/>
                    <a target="_blank" href="<?php echo e($settings['booking_appointment_url']); ?>" class="butn primary_butn"><b>Book Appointment</b></a>
                    <?php if($lang == 'ar'): ?>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL('en', null, [], true)); ?>" class="butn secondary_butn sm_butn ms-2"><b><?php echo e(__('main.another_lang_abbr')); ?></b></a>
                    <?php else: ?>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL('ar', null, [], true)); ?>" class="butn secondary_butn sm_butn ms-2"><b><?php echo e(__('main.another_lang_abbr')); ?></b></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>
</div>
<?php /**PATH C:\wamp64\www\procare\resources\views/web/layouts/nav.blade.php ENDPATH**/ ?>