<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($partner ?? ''  && $partner->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>


        <div class="form-group col-lg-3">
            <label><?php echo e(meta('type', $lang) ?? __('partners.type')); ?> </label>
            <select name="type" class="form-control <?php echo e($errors->has('type') ? 'is-invalid' : ''); ?>">
                <option <?php echo e(old('type', $partner->type ?? null) == 'partner' ? 'selected' : ''); ?> value="partner"><?php echo e(__('partners.partner')); ?></option>
                <option <?php echo e(old('type', $partner->type ?? null) == 'insurance' ? 'selected' : ''); ?> value="insurance"><?php echo e(__('partners.insurance')); ?></option>
            </select>
        </div>
        <div class="form-group col-lg-9">
            <label><?php echo e(meta('url', $lang) ?? __('partners.url')); ?> </label>
            <input type="url"  class="form-control <?php echo e($errors->has('url') ? 'is-invalid' : ''); ?>" name="url" placeholder="<?php echo e(meta('url', $lang) ?? __('partners.url')); ?>" value='<?php echo e(old("url", $partner->url ?? "")); ?>'/>
        </div>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('name', $language->local) ?? __('pages.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('pages.name')); ?>" value='<?php echo e(old("name_{$language->local}", $partner[$language->local]->name ?? "")); ?>'/>
        </div>






















        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('image', getCurrentLocale()) ?? __('pages.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $partner->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $partner->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $partner->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $partner->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
        <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>

    <script>
        var route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>";
        var url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e(getCurrentLocale()); ?>",
            inputName = '';
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/partners/form.blade.php ENDPATH**/ ?>