<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($workHour ?? ''  && $workHour->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="form-group col-lg-3">
                <label><?php echo e(meta('week_day', $lang) ?? __('workHours.week_day')); ?> </label>
                <select name="week_day" class="form-control <?php echo e($errors->has('week_day') ? 'is-invalid' : ''); ?>">
                    <?php if(count($weekDays)): ?>
                        <?php $__currentLoopData = $weekDays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $weekDay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(old('week_day', $workHour->week_day ?? null) == $key ? 'selected' : ''); ?> value="<?php echo e($key); ?>"><?php echo e($weekDay); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <div class="form-group col-lg-3">
                <label><?php echo e(meta('status', $lang) ?? __('workHours.status')); ?> </label>
                <select name="status" class="form-control <?php echo e($errors->has('status') ? 'is-invalid' : ''); ?>">
                    <option <?php echo e(old('status', $workHour->status ?? null) == 'open' ? 'selected' : ''); ?> value="open"><?php echo e(__('workHours.open')); ?></option>
                    <option <?php echo e(old('status', $workHour->status ?? null) == 'closed' ? 'selected' : ''); ?> value="closed"><?php echo e(__('workHours.closed')); ?></option>
                </select>
            </div>

            <div class="form-group col-lg-3 input_time <?php echo e(($workHour->status ?? null) == 'closed' ? 'd-none' : ''); ?>">
                <label><?php echo e(meta('time_from', $lang) ?? __('workHours.name')); ?></label>
                <input type="time" class="form-control <?php echo e($errors->has('time_from') ? 'is-invalid' : ''); ?>" name="time_from" placeholder="<?php echo e(meta('time_from', $lang) ?? __('workHours.time_from')); ?>" value='<?php echo e(old("time_from", $workHour->time_from ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-3 input_time <?php echo e(($workHour->status ?? null) == 'closed' ? 'd-none' : ''); ?>">
                <label><?php echo e(meta('time_to', $lang) ?? __('workHours.name')); ?></label>
                <input type="time" class="form-control <?php echo e($errors->has('time_to') ? 'is-invalid' : ''); ?>" name="time_to" placeholder="<?php echo e(meta('time_to', $lang) ?? __('workHours.time_to')); ?>" value='<?php echo e(old("time_to", $workHour->time_to ?? "")); ?>'/>
            </div>

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <script>
        sendAjax('.add_button', '.add_form');

        $('select[name="status"]').change(function () {
            if($(this).val() === 'closed'){
                $('input[type="time"]').val('');
                $('.input_time').addClass('d-none');
            }
            if($(this).val() === 'open'){
                $('.input_time').removeClass('d-none');
            }
        })
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/work_hours/form.blade.php ENDPATH**/ ?>