<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="<?php echo e($action); ?>">
        <?php if($video ?? ''  && $video->id ?? ''): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('video_category_id', getCurrentLocale()) ?? __('videos.category')); ?> </label>
            <select name="video_category_id" id="video_category_id" class="form-control <?php echo e($errors->has('video_category_id') ? 'is-invalid' : ''); ?>">
                <option value=""><?php echo e(meta('video_category_id', getCurrentLocale()) ?? __('videos.category')); ?></option>
                <?php $__currentLoopData = videoCategories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $videoCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option <?php echo e(old("video_category_id", $video->video_category_id ?? "") == $videoCategory->id ? 'selected': ''); ?> value="<?php echo e($videoCategory->id); ?>"><?php echo e(descriptions($videoCategory)->name ?? ''); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('title', $language->local) ?? __('videos.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('videos.name')); ?>" value='<?php echo e(old("title_{$language->local}", $video[$language->local]->title ?? "")); ?>'/>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('type', getCurrentLocale()) ?? __('videos.type')); ?> </label>
            <div class="card p-1">
                <div class="d-flex p-2">
                    <div class="col-md-6 custom-control custom-radio">
                        <input <?php echo e(old('type', $video->type ?? '') == 1 ? 'checked' : 'checked'); ?> id="external" type="radio" class="custom-control-input external" name="type" value='1'/>
                        <label for="external" class="custom-control-label"><?php echo e(meta('external_link', getCurrentLocale()) ?? __('videos.external_link')); ?> </label>
                    </div>
                    <div class="col-md-6 custom-control custom-radio ">
                        <input <?php echo e(old('type', $video->type ?? '') == 2 ? 'checked' : ''); ?> id="local" type="radio" class="custom-control-input local" name="type" value='2'/>
                        <label for="local" class="custom-control-label"><?php echo e(meta('local_link', getCurrentLocale()) ?? __('videos.local_link')); ?> </label>
                    </div>
                </div>
            </div>
        </div>
        

        
        <div class="form-group col-lg-12 url_container  d-none">
            <label><?php echo e(meta('video_url', getCurrentLocale()) ?? __('videos.url')); ?></label>
            <input type="text" class="form-control url <?php echo e($errors->has('video_url') ? 'is-invalid' : ''); ?>" name="video_url" placeholder="<?php echo e(meta('video_url', getCurrentLocale()) ?? __('videos.url')); ?>" value='<?php echo e(old("video_url", $video->video ?? "")); ?>'/>
        </div>
        

        
        <div class="form-group col-lg-12 video_container d-none">
            <label><?php echo e(meta('video', getCurrentLocale()) ?? __('videos.video')); ?> </label>
            <input id="video_thumbnail" class="video_thumbnail" type="hidden" name="video" value="<?php echo e(old("video", $video->video ?? "")); ?>"/>

            <div class="photos main_video <?php echo e(old('video', $video->video ?? '') ? '' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div>
                            <a href="<?php echo e(asset(old('video', $video->video ?? ''))); ?>" class="btn btn-primary video_href" target="_blank" > Browse </a>

                            <a id="lfm" data-input=".video_thumbnail" data-href=".video_href" data-preview=".video_holder" data-show=".main_video" data-hide=".pick_video_button" class="lfm btn btn-primary ml-4 text-light">
                                <i class="fas fa-video"></i> Choose
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".video_thumbnail" data-hide=".main_video" data-show=".pick_video_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_video_button <?php echo e(old('video', $video->video ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".video_thumbnail" data-href=".video_href" data-preview=".video_holder" data-show=".main_video" data-hide=".pick_video_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-video"></i> Choose
                </a>
            </span>

        </div>
        

        
        <?php if(preg_match('/https:\/\/img\.youtube\.com/', $video->image ?? '', $match) ): ?>

            <div class="form-group col-lg-12 youtube_thumbnails">
                <label><?php echo e(meta('image', getCurrentLocale()) ?? __('videos.image')); ?> </label>
                <div class="photos <?php echo e($video->image ?? '' ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-lg-4">
                        <div class="items">
                            <div class="img">
                                <a target="_blank" href="<?php echo e($video->image ?? ''); ?>" >
                                    <img src="<?php echo e($video->image ?? ''); ?>">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="form-group col-lg-12 image_container d-none">
            <label><?php echo e(meta('image', getCurrentLocale()) ?? __('videos.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $video->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $video->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $video->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $video->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->

        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e(getCurrentLocale()); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/videos.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\cms\resources\views/admin/videos/form.blade.php ENDPATH**/ ?>