<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_doctor_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($doctor ?? ''  && $doctor->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="form-group col-lg-6">
                <label><?php echo e(meta('facebook', $lang) ?? __('doctors.facebook')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('facebook') ? 'is-invalid' : ''); ?>" name="facebook" placeholder="<?php echo e(meta('facebook', $lang) ?? __('doctors.facebook')); ?>" value='<?php echo e(old("facebook", $doctor->facebook ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('twitter', $lang) ?? __('doctors.twitter')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('twitter') ? 'is-invalid' : ''); ?>" name="twitter" placeholder="<?php echo e(meta('twitter', $lang) ?? __('doctors.twitter')); ?>" value='<?php echo e(old("twitter", $doctor->twitter ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('instagram', $lang) ?? __('doctors.instagram')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('instagram') ? 'is-invalid' : ''); ?>" name="instagram" placeholder="<?php echo e(meta('instagram', $lang) ?? __('doctors.instagram')); ?>" value='<?php echo e(old("instagram", $doctor->instagram ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('linkedin', $lang) ?? __('doctors.linkedin')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('linkedin') ? 'is-invalid' : ''); ?>" name="linkedin" placeholder="<?php echo e(meta('linkedin', $lang) ?? __('doctors.linkedin')); ?>" value='<?php echo e(old("linkedin", $doctor->linkedin ?? "")); ?>'/>
            </div>


            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('name', $language->local) ?? __('doctors.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('doctors.name')); ?>" value='<?php echo e(old("name_{$language->local}", $doctor[$language->local]->name ?? "")); ?>'/>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('specialist', $language->local) ?? __('doctors.specialist')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="specialist_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('specialist_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('specialist', $language->local) ?? __('doctors.specialist')); ?>"><?php echo e(old("specialist_{$language->local}", $doctor[$language->local]->specialist ?? "")); ?></textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('certifications', $language->local) ?? __('doctors.certifications')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="certifications_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('certifications_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('certifications', $language->local) ?? __('doctors.certifications')); ?>"><?php echo e(old("certifications_{$language->local}", $doctor[$language->local]->certifications ?? "")); ?></textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('trainings', $language->local) ?? __('doctors.trainings')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="trainings_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('trainings_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('trainings', $language->local) ?? __('doctors.trainings')); ?>"><?php echo e(old("trainings_{$language->local}", $doctor[$language->local]->trainings ?? "")); ?></textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('experiences', $language->local) ?? __('doctors.experiences')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="experiences_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('experiences_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('experiences', $language->local) ?? __('doctors.experiences')); ?>"><?php echo e(old("experiences_{$language->local}", $doctor[$language->local]->experiences ?? "")); ?></textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('researches', $language->local) ?? __('doctors.researches')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="researches_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('researches_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('researches', $language->local) ?? __('doctors.researches')); ?>"><?php echo e(old("researches_{$language->local}", $doctor[$language->local]->researches ?? "")); ?></textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('professional_memberships', $language->local) ?? __('doctors.professional_memberships')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="professional_memberships_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('professional_memberships_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('professional_memberships', $language->local) ?? __('doctors.professional_memberships')); ?>"><?php echo e(old("professional_memberships_{$language->local}", $doctor[$language->local]->professional_memberships ?? "")); ?></textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('details', $language->local) ?? __('doctors.details')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="details_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('details_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('details', $language->local) ?? __('doctors.details')); ?>"><?php echo e(old("details_{$language->local}", $doctor[$language->local]->details ?? "")); ?></textarea>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <div class="form-group col-lg-12 image_container">
                <label><?php echo e(meta('image', $lang) ?? __('doctors.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $doctor->image ?? "")); ?>"/>

                <div class="photos main_photo <?php echo e(old('image', $doctor->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $doctor->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button <?php echo e(old('image', $doctor->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
            </div>
            


        <div class="text-center mt-5 col-12">
            <button class="butn add_doctor_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_doctor_button', '.add_doctor_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/doctors/form.blade.php ENDPATH**/ ?>