<?php $__env->startSection('content'); ?>
    <div class="side-title">
        <h3><?php echo e($head ?? ''); ?></h3>
    </div>

    <div class="border-item">
        <form class="form-row" method="post" action="<?php echo e($action); ?>">
            <?php if($user ?? ''  && $user->id): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <?php echo csrf_field(); ?>

            <div class="form-group col-lg-4">
                <label><?php echo e(meta('name', $lang) ?? __('users.name')); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" name="name" placeholder="<?php echo e(meta('name', $lang) ??__('users.name')); ?>" value='<?php echo e(old("name", $user->name ?? "")); ?>'/>
            </div>

            <div class="form-group col-lg-4">
                <label><?php echo e(meta('email', $lang) ?? __('users.email')); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" name="email" placeholder="<?php echo e(meta('email', $lang) ?? __('users.email')); ?>" value='<?php echo e(old("email", $user->email ?? "")); ?>' <?php echo e(($user->email ?? null) ? "readonly" : ""); ?>/>
            </div>

            <div class="form-group col-lg-4">
                <label><?php echo e(meta('phone', $lang) ?? __('users.phone')); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('phone') ? 'is-invalid' : ''); ?>" name="phone" placeholder="<?php echo e(meta('phone', $lang) ?? __('users.phone')); ?>" value='<?php echo e(old("phone", $user->phone ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('password', $lang) ?? __('users.password')); ?> </label>
                <input type="password" class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" name="password" placeholder="<?php echo e(meta('password', $lang) ?? __('users.password')); ?>" value='<?php echo e(old("password", "")); ?>'/>
            </div>

            <div class="form-group col-lg-6">
                <label><?php echo e(meta('password_confirmation', $lang) ?? __('users.password_confirmation')); ?> </label>
                <input type="password" class="form-control <?php echo e($errors->has('password_confirmation') ? 'is-invalid' : ''); ?>" name="password_confirmation" placeholder="<?php echo e(meta('password_confirmation', $lang) ?? __('users.password_confirmation')); ?>" value='<?php echo e(old("password_confirmation", "")); ?>'/>
            </div>

            <?php if(auth()->user()->role != 'sub_admin' && ($user->role ?? $request->role ?? 'sub_admin') == 'sub_admin'): ?>
                <?php if( count($modules) >= 1 ): ?>
                    <div class="form-group col-lg-12">
                        <label><?php echo e(meta('modules', $lang) ??  __('users.modules')); ?> </label>
                        <div class="clearfix"></div>
                        <div class="row">
                            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-sm-4">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" <?php echo e(in_array($row['id'], $user_modules) ? 'checked' : ''); ?> value="<?php echo e($row['id']); ?>" class="custom-control-input" id="module_<?php echo e($key); ?>" name="modules[]">
                                        <label class="custom-control-label" for="module_<?php echo e($key); ?>"> <?php echo e($row->meta['module_name'][$lang] ?? __($row['path'].'.head')); ?> </label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

                
                <div class="form-group col-lg-6">
                    <label><?php echo e(meta('photo', $lang) ?? __('users.photo')); ?> </label>
                    <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="photo" value="<?php echo e(old("photo", $user->photo ?? "")); ?>"/>

                    <div class="photos main_photo <?php echo e(old('photo', $user->photo ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                        <div class="col-lg-12">
                            <div class="items">
                                <div class="img">
                                    <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                        <img src="<?php echo e(asset(old('photo', $user->photo ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                    </a>
                                </div>
                                <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <span class="input-group-btn pick_button <?php echo e(old('photo', $user->photo ?? '') ? 'hide' : ''); ?> ">
                    <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> Choose
                    </a>
                </span>
                </div>
                

            <div class="text-center mt-5 col-12">
                <button class="butn"><span><?php echo e(__('dashboard.save')); ?></span></button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    
    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/users/form.blade.php ENDPATH**/ ?>