<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="<?php echo e($settings['meta_description']); ?> - <?php echo e($meta_description ?? ($title ?? '')); ?>" />
    <meta name="keywords" content="<?php echo e($settings['keywords']); ?> , <?php echo e($keywords ??  ($title ?? '')); ?>" />

    <title><?php echo e($settings['website_name']); ?> - <?php echo e(($title ?? '')); ?></title>

    <link rel="shortcut icon" href="<?php echo e(getImage($settings['website_logo'])); ?>" type="image/x-icon" />
    
    
    <!--Css Files & Libraries-->
    <?php if('en' == $lang): ?>
        <!--With ltr -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/bootstrap-ltr.min.css')); ?>"/>
    <?php else: ?>        
        <!--With RTL -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/bootstrap-rtl.min.css')); ?>"/>
    <?php endif; ?>

    <link href="https://fonts.googleapis.com/css2?family=Marcellus&family=Poppins:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/jquery.fancybox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/styles.css')); ?>" />
    <?php if('ar' == $lang): ?>
        <!--With RTL -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/style_ar.css')); ?>" />
    <?php endif; ?>
    

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/toastr.css')); ?>">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


</head>

<body>
    <?php echo $__env->make('web.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(asset('assets/web/js/lib/jquery-3.0.0.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/jquery-migrate-3.0.0.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/popper.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/bootstrap.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/wow.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/jquery.fancybox.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/owl.carousel.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/swiper.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/web/js/lib/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/web/js/lib/jquery.counterup.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/web/js/main.js')); ?> "></script>


    
    <script src="<?php echo e(asset('assets/web/js/lib/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/web/js/lib/axios.min.js')); ?>"></script>
    <script>
        axios.defaults.headers.common = {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN' : document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        };
    </script>
    <script src="<?php echo e(asset('assets/web/js/actions.js')); ?>"></script>

    <?php echo $__env->yieldContent('content_js'); ?>
</body>

</html>
<?php /**PATH C:\wamp64\www\cms\resources\views/web/layouts/layout.blade.php ENDPATH**/ ?>