<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="<?php echo e(auth()->id()); ?>">
        <?php if($gallery ?? ''  && $gallery->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('type', $lang) ?? __('galleries.type')); ?> </label>
            <select name="type" class="form-control <?php echo e($errors->has('type') ? 'is-invalid' : ''); ?>">
                <option <?php echo e(old('type', $gallery->type ?? null) == 'image_type' ? 'selected' : ''); ?> value="image_type"><?php echo e(__('galleries.image_type')); ?></option>
                <option <?php echo e(old('type', $gallery->type ?? null) == 'video_type' ? 'selected' : ''); ?> value="video_type"><?php echo e(__('galleries.video_type')); ?></option>
                <option <?php echo e(old('type', $gallery->type ?? null) == 'magazine_type' ? 'selected' : ''); ?> value="magazine_type"><?php echo e(__('galleries.magazine_type')); ?></option>
            </select>
        </div>

        <div class="form-group video_url col-lg-12 <?php echo e(($gallery->video_url ?? null) ? '' : 'd-none'); ?>">
            <label><?php echo e(meta('video_url', $lang) ?? __('galleries.video_url')); ?> </label>
            <input type="url" class="form-control <?php echo e($errors->has('video_url') ? 'is-invalid' : ''); ?>" name="video_url" placeholder="<?php echo e(meta('video_url', $lang) ?? __('galleries.video_url')); ?>" value='<?php echo e(old("video_url", $gallery->video_url ?? "")); ?>'/>
        </div>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('title', $language->local) ?? __('galleries.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('galleries.title')); ?>" value='<?php echo e(old("title_{$language->local}", $gallery[$language->local]->title ?? "")); ?>'/>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12 image_container">
            <label><?php echo e(meta('image', $lang) ?? __('doctors.image')); ?>

                <br> <span class="text-danger"><?php echo e(__('galleries.image_file_types')); ?></span>
            </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $gallery->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $gallery->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-md-4">
                    <div class="items">
                        <div class="img">
                            <?php if(strpos(($gallery->image ?? null), '.pdf')): ?>
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', 'assets/admin/images/file-icon.png'))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            <?php else: ?>
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $gallery->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            <?php endif; ?>

                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $gallery->image ?? '') ? 'hide' : ''); ?>">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm lfm_file btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
        </div>
        


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
        let imgSrc = "<?php echo e(asset('assets/admin/images/file-icon.png')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script>
        sendAjax('.add_button', '.add_form');



        $('select[name="type"]').change(function(){
            if($(this).val() === 'video_type'){
                $('.video_url').removeClass('d-none');
            } else {
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val('');
            }
        });



    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/galleries/form.blade.php ENDPATH**/ ?>