<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($conference ?? ''  && $conference->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="form-group col-lg-6">
                <label><?php echo e(meta('start_date', $lang) ?? __('conferences.start_date')); ?> </label>
                <input type="date" class="form-control <?php echo e($errors->has('start_date') ? 'is-invalid' : ''); ?>" name="start_date" placeholder="<?php echo e(meta('start_date', $lang) ?? __('conferences.start_date')); ?>" value='<?php echo e(old("start_date", $conference->start_date ?? null)); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('end_date', $lang) ?? __('conferences.end_date')); ?> </label>
                <input type="date" class="form-control <?php echo e($errors->has('end_date') ? 'is-invalid' : ''); ?>" name="end_date" placeholder="<?php echo e(meta('end_date', $lang) ?? __('conferences.end_date')); ?>" value='<?php echo e(old("end_date", $conference->end_date ?? null)); ?>'/>
            </div>

            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('title', $language->local) ?? __('conferences.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('conferences.title')); ?>" value='<?php echo e(old("title_{$language->local}", $conference[$language->local]->title ?? null)); ?>'/>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('description', $language->local) ?? __('conferences.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="description_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('conferences.description')); ?>"><?php echo e(old("description_{$language->local}", $conference[$language->local]->description ?? null)); ?></textarea>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <div class="form-group col-lg-12 image_container">
                <label><?php echo e(meta('image', $lang) ?? __('conferences.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $conference->image ?? null)); ?>"/>

                <div class="photos main_photo <?php echo e(old('image', $conference->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $conference->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button <?php echo e(old('image', $conference->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
            </div>
            


            
            <div class="border-item photos col-md-12 other_image_container">
                <div class="row">
                    <?php if(is_array($conference->files ?? []) && count($conference->files ?? [])): ?>
                        <?php $__currentLoopData = $conference->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $files): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4">
                                <div class="items">
                                    <div class="img">
                                        <a href="<?php echo e(asset('assets/admin/images/icons/pdf.svg')); ?>" data-fancybox="gallery"><img src="<?php echo e(asset('assets/admin/images/icons/pdf.svg')); ?>" alt=""></a>
                                    </div>
                                    <input type="hidden" name="files[]" value="<?php echo e($files ?? null); ?>">
                                    <a href="#" class="close"><i class="fas fa-times"></i></a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
                <div class="text-center">
                    <input id="other_image_thumbnail" class="other_image_thumbnail" type="hidden"/>
                    <div class="clearfix"></div>
                    <span id="add">
                    <a id="lfm" data-type-file="true" data-width="" data-cache="article_gallery" data-input=".other_image_thumbnail" data-preview="" data-show="" data-hide="" class="lfm_file add">
                        <?php echo e(__('dashboard.add_new_file')); ?>

                    </a>
                </span>
                </div>
            </div>
            


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imageTitle = "<?php echo e(meta('image_title', $lang) ?? null); ?>",
            inputName = null,
            thumbnail = "<?php echo e(asset('assets/admin/images/icons/pdf.svg')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/articles.js')); ?>"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\procare\resources\views/admin/conferences/form.blade.php ENDPATH**/ ?>