<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($page ?? ''  && $page->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('title', $language->local) ?? __('pages.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('pages.title')); ?>" value='<?php echo e(old("title_{$language->local}", $page[$language->local]->title ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('slug', $language->local) ?? __('pages.slug')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('slug_'.$language->local) ? 'is-invalid' : ''); ?>" name="slug_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('slug', $language->local) ?? __('pages.slug')); ?>" value='<?php echo e(old("slug_{$language->local}", $page[$language->local]->slug ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('keywords', $language->local) ?? __('pages.keywords')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('keywords_'.$language->local) ? 'is-invalid' : ''); ?>" name="keywords_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('keywords', $language->local) ?? __('pages.keywords')); ?>" value='<?php echo e(old("keywords_{$language->local}", $page[$language->local]->keywords ?? "")); ?>'/>

        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('meta_description', $language->local) ?? __('pages.meta_description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('meta_description_'.$language->local) ? 'is-invalid' : ''); ?>" name="meta_description_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('meta_description', $language->local) ?? __('pages.meta_description')); ?>" value='<?php echo e(old("meta_description_{$language->local}", $page[$language->local]->meta_description ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('description', $language->local) ?? __('pages.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <textarea name="description_<?php echo e($language->local); ?>" class="form-control my-editor <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('pages.description')); ?>"><?php echo e(old("description_{$language->local}", $page[$language->local]->description ?? "")); ?></textarea>
        </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('image', $lang) ?? __('pages.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $page->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $page->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $page->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $page->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->

    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\cms\resources\views/admin/pages/form.blade.php ENDPATH**/ ?>