<?php $__env->startSection('content'); ?>

<div class="row">
    <?php for($i = 1; $i < 13 ; $i++): ?>
        <?php if(array_key_exists($i, $monthVisitCounts)): ?>
            <?php continue; ?>
        <?php endif; ?>
        <?php $monthVisitCounts[$i] = 0; ?>
    <?php endfor; ?>

    <?php ksort($monthVisitCounts); ?>



    <?php $__currentLoopData = $monthVisitCounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <input type="hidden" name="<?php echo e($month); ?>" value="<?php echo e($count); ?>" class="monthVisitCounts">
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    <!-- ------------ line chart ------------- -->
    <input type="hidden" value="<?php echo e($allVisitorCounts); ?>" class="allVisitorCounts">
    <div class="col-lg-12">
        <h5 class="text-uppercase font-weight-bold"><?php echo e(__('dashboard.view_in_year')); ?></h5>
        <canvas class="border-item lineChart" width="400" height="150"></canvas>
    </div>














    <div class="col-lg-6 mb-3">
        <div class="new-users border-item">
            <div class="datatitle">
                <h6 class="text-uppercase font-weight-bold"><?php echo e(__('dashboard.view_in_year')); ?> (<?php echo e(date('Y')); ?>)</h6>
                <p><?php echo e(__('dashboard.year')); ?>: <?php echo e(date('Y')); ?></p>
            </div>

            <div class="items">
                <span class="number text-primary">
                    <?php
                        /** @var TYPE_NAME $allVisitorCounts */
                        $percentage = $allVisitorCounts > 0 ? ($allVisitorCounts*100)/$allVisitorCounts . '%' : '0 %';
                    ?>
                    <?php echo e($allVisitorCounts); ?>

                </span>
                <div class="progress-item">
                    <p class="info"> <?php echo e(__('dashboard.visits')); ?> </p>
                    <div class="progress"><span class="bg-primary" data-value="<?php echo e($percentage); ?>"></span></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6 mb-3">
        <div class="new-users border-item">
            <div class="datatitle">
                <h6 class="text-uppercase font-weight-bold"><?php echo e(__('dashboard.view_in_month')); ?> (<?php echo e(date('F')); ?>)</h6>
                <p><?php echo e(__('dashboard.month')); ?>: <?php echo e(date('m')); ?></p>
            </div>

            <div class="items">
                <span class="number text-primary">
                    <?php
                        /** @var TYPE_NAME $monthVisitCounts */
                        /** @var TYPE_NAME $allVisitorCounts */
                        $month = date('n');
                        $count = $monthVisitCounts[$month];
                        $percentage = $count > 0 ? ($count*100)/$allVisitorCounts . '%' : '0 %';
                    ?>
                    <?php echo e($count); ?>

                </span>
                <div class="progress-item">
                    <p class="info"> <?php echo e(__('dashboard.visits')); ?> </p>
                    <div class="progress"><span class="bg-primary" data-value="<?php echo e($percentage); ?>"></span></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6 mb-3">
        <div class="new-users border-item">
            <div class="datatitle">
                <h6 class="text-uppercase font-weight-bold"><?php echo e(__('dashboard.view_in_week')); ?> (<?php echo e(date('W')); ?>)</h6>
                <p><?php echo e(__('dashboard.week')); ?>: <?php echo e(date('W')); ?></p>
            </div>

            <div class="items">
                <span class="number text-primary">
                    <?php
                        /** @var TYPE_NAME $weekVisitorCounts */
                        $percentage = $weekVisitorCounts > 0 ? ($weekVisitorCounts*100)/$allVisitorCounts . '%' : '0 %';
                    ?>
                    <?php echo e($weekVisitorCounts); ?>

                </span>
                <div class="progress-item">
                    <p class="info"> <?php echo e(__('dashboard.visits')); ?> </p>
                    <div class="progress"><span class="bg-primary" data-value="<?php echo e($percentage); ?>"></span></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6 mb-3">
        <div class="new-users border-item">
            <div class="datatitle">
                <h6 class="text-uppercase font-weight-bold"><?php echo e(__('dashboard.view_in_day')); ?> (<?php echo e(date('l')); ?>)</h6>
                <p><?php echo e(__('dashboard.day')); ?>: <?php echo e(date('F')); ?></p>
            </div>

            <div class="items">
                <span class="number text-primary">
                    <?php
                        /** @var TYPE_NAME $dayVisitCounts */
                        $percentage = !empty($dayVisitCounts) ? ($dayVisitCounts*100)/$allVisitorCounts . '%' : '0 %'
                    ?>
                    <?php echo e(!empty($dayVisitCounts) ? $dayVisitCounts : 0); ?>

                </span>
                <div class="progress-item">
                    <p class="info"> <?php echo e(__('dashboard.visits')); ?> </p>
                    <div class="progress"><span class="bg-primary" data-value="<?php echo e($percentage); ?>"></span></div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12 mt-5">
        <table class="table table-bordered shadow">
            <thead>
            <tr>
                <td colspan="3" class="card-header text-center">
                    <h5 class="text-uppercase font-weight-bold">Most viewed articles</h5>
                </td>
            </tr>
            <tr class="bg-dark text-white">
                <th style="width: 10%" class="text-center">Serial</th>
                <th>Article title</th>
                <th style="width: 15%" class="text-center">Visited count</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($article->title); ?></td>
                    <td><?php echo e($article->visit_counts); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
    </div>


</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

<script src="<?php echo e(asset('assets/admin/js/lib/Chart.min.js')); ?>"></script>
<script>
    $(document).ready(function () {
        let months = [],
            month_visits = [],
            allVisitorCounts = $('.allVisitorCounts').val(),
            ChartHtml = $('.lineChart').html('2d');

        $('.monthVisitCounts').each(function () {
            months.push($(this).attr('name'));
            month_visits.push($(this).val());
        });

        month_visits.push(allVisitorCounts);

        new Chart(ChartHtml, {
            type: 'line',
            data: {
                labels: months,
                datasets: [{
                    label: ' people',
                    data: month_visits,
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(153, 102, 255, 0.2)',
                        'rgba(255, 159, 64, 0.2)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true
                        }
                    }]
                }
            }
        });
    })
</script>
















<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\cms\resources\views/admin/index.blade.php ENDPATH**/ ?>