<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>
<div class="border-item">
    <form class="form-row save_data_form" method="post" action="<?php echo e($action); ?>">

        <?php if($photoCategory ?? ''  && $photoCategory->id ?? ''): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <div class="side-title col-md-12">
            <div class="row">
                <div class="col-lg-3">
                    <h3><?php echo e(meta('gallery_title', $lang) ?? 'gallery title'); ?></h3>
                </div>
                <div class="col-lg-3 valign">
                    <div class="add-title w-100">
                        <div class="form-group">
                            <input type="text" class="form-control <?php echo e($errors->has('name_'.$lang) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($lang); ?>" placeholder="<?php echo e(meta('name', $lang) ?? __('photoCategories.name')); ?>" value='<?php echo e(old("name_".$lang, $photoCategory ?? '' ? descriptions($photoCategory)->name : "")); ?>'/>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 valign">
                    <div class="add-title w-100">
                        <div class="form-group">
                            <input type="text" class="form-control <?php echo e($errors->has('slug_'.$lang) ? 'is-invalid' : ''); ?>" name="slug_<?php echo e($lang); ?>" placeholder="<?php echo e(meta('slug', $lang) ?? __('photoCategories.slug')); ?>" value='<?php echo e(old("slug_".$lang, $photoCategory ?? '' ? descriptions($photoCategory)->slug : "")); ?>'/>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 valign">
                    <div class="edit-buttons text-right w-100">
                        <button type="submit" class="butn bg-success save_data_button"><?php echo e(__('dashboard.save')); ?></button>
                        <button type="reset" class="butn btn-primary">reset</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="border-item photos col-md-12">
            <div class="row">
                <?php if($photoCategory ?? false): ?>
                    <?php $__currentLoopData = $photoCategory['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4">
                            <div class="items">
                                <div class="img">
                                    <a href="<?php echo e(asset($photo->image ?? '')); ?>" data-fancybox="gallery"><img src="<?php echo e(asset($photo->image ?? '')); ?>" alt=""></a>
                                </div>
                                <input type="hidden" name="images[]" value="<?php echo e($photo->image ?? ""); ?>">







                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <div class="text-center">
                <input id="image_thumbnail" class="image_thumbnail" type="hidden"/>
                <div class="clearfix"></div>
                <span class="pick_button" id="add">
                    <a id="lfm" data-cache="photo_gallery" data-title="false" data-url="" data-width="" data-input=".image_thumbnail" data-preview=".image_holder" data-show="" data-hide="" class="lfm add">
                        <?php echo e(__('dashboard.add_new_item')); ?>

                    </a>
                </span>
            </div>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>

    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imageTitle = "<?php echo e(meta('image_title', $lang) ?? null); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/photos.js')); ?>"></script>

    <script>
        sendAjax('.save_data_button', '.save_data_form')
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\nesma_cnc\resources\views/admin/photo_categories/form.blade.php ENDPATH**/ ?>