<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="<?php echo e(auth()->id()); ?>">
        <?php if($article ?? ''  && $article->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('category_id', $lang) ?? __('articles.category')); ?></label>
            <select name="category_id" id="category_id" class="form-control my-editor <?php echo e($errors->has('category_id') ? 'is-invalid' : ''); ?>">
                <option value=""><?php echo e(meta('category_id', $lang) ?? __('articles.category')); ?></option>
                <?php $__currentLoopData = articleCategories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option <?php echo e(old("category_id", $article->category_id ?? "") == $category->id ? 'selected': ''); ?> value="<?php echo e($category->id); ?>"><?php echo e(descriptions($category)->name ?? ''); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('title', $language->local) ?? __('articles.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('articles.title')); ?>" value='<?php echo e(old("title_{$language->local}", $article[$language->local]->title ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('slug', $language->local) ?? __('articles.slug')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('slug_'.$language->local) ? 'is-invalid' : ''); ?>" name="slug_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('slug', $language->local) ?? __('articles.slug')); ?>" value='<?php echo e(old("slug_{$language->local}", $article[$language->local]->slug ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('keywords', $language->local) ?? __('articles.keywords')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('keywords_'.$language->local) ? 'is-invalid' : ''); ?>" name="keywords_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('keywords', $language->local) ?? __('articles.keywords')); ?>" value='<?php echo e(old("keywords_{$language->local}", $article[$language->local]->keywords ?? "")); ?>'/>

        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('meta_description', $language->local) ?? __('articles.meta_description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('meta_description_'.$language->local) ? 'is-invalid' : ''); ?>" name="meta_description_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('meta_description', $language->local) ?? __('articles.meta_description')); ?>" value='<?php echo e(old("meta_description_{$language->local}", $article[$language->local]->meta_description ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('description', $language->local) ?? __('articles.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <textarea name="description_<?php echo e($language->local); ?>" class="form-control my-editor <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('articles.description')); ?>"><?php echo e(old("description_{$language->local}", $article[$language->local]->description ?? "")); ?></textarea>
        </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('video_type', $lang) ?? __('articles.type')); ?> </label>
            <div class="card p-1">
                <div class="d-flex p-2">
                    <div class="col-md-6 custom-control custom-radio">
                        
                        <input <?php echo e(old('video_type', $article->video_type ?? '') == 1 ? 'checked' : ''); ?> id="external" type="radio" class="custom-control-input external" name="video_type" value='1'/>
                        <label for="external" class="custom-control-label"><?php echo e(meta('external_link', $lang) ?? __('articles.external_link')); ?> </label>
                    </div>
                    <div class="col-md-6 custom-control custom-radio ">
                        <input <?php echo e(old('video_type', $article->video_type ?? '') == 2 ? 'checked' : ''); ?> id="local" type="radio" class="custom-control-input local" name="video_type" value='2'/>
                        <label for="local" class="custom-control-label"><?php echo e(meta('local_link', $lang) ?? __('articles.local_link')); ?> </label>
                    </div>
                </div>
            </div>
        </div>
        

        
        <div class="form-group col-lg-12 url_container d-none">
            <label><?php echo e(meta('video_url', $lang) ?? __('articles.url')); ?></label>
            <input type="text" class="form-control url <?php echo e($errors->has('video_url') ? 'is-invalid' : ''); ?>" name="video_url" placeholder="<?php echo e(meta('video_url', $lang) ?? __('articles.url')); ?>" value='<?php echo e(old("video_url", $article->video ?? "")); ?>'/>
        </div>
        

        
        <div class="form-group col-lg-12 video_container d-none">
            <label><?php echo e(meta('video', $lang) ?? __('articles.video')); ?> </label>
            <input id="video_thumbnail" class="video_thumbnail" type="hidden" name="video" value="<?php echo e(old("video", $article->video ?? "")); ?>"/>

            <div class="photos main_video <?php echo e(old('video', $article->video ?? '') ? '' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div>
                            <a href="<?php echo e(asset(old('video', $article->video ?? ''))); ?>" class="btn btn-primary video_href" target="_blank" > Browse </a>

                            <a id="lfm" data-input=".video_thumbnail" data-href=".video_href" data-preview=".video_holder" data-show=".main_video" data-hide=".pick_video_button" class="lfm btn btn-primary ml-4 text-light">
                                <i class="fas fa-video"></i> Choose
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".video_thumbnail" data-hide=".main_video" data-show=".pick_video_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_video_button <?php echo e(old('video', $article->video ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".video_thumbnail" data-href=".video_href" data-preview=".video_holder" data-show=".main_video" data-hide=".pick_video_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-video"></i> Choose
                </a>
            </span>

        </div>
        


        
        <?php if(preg_match('/https:\/\/img\.youtube\.com/', $article->image ?? '', $match) ): ?>
            <div class="form-group col-lg-12 youtube_thumbnails">
                <label><?php echo e(meta('image', $lang) ?? __('articles.image')); ?> </label>
                <div class="photos <?php echo e($article->image ?? '' ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-lg-4">
                        <div class="items">
                            <div class="img">
                                <a target="_blank" href="<?php echo e($article->image ?? ''); ?>" >
                                    <img src="<?php echo e($article->image ?? ''); ?>">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="form-group col-lg-12 image_container d-none">
            <label><?php echo e(meta('image', $lang) ?? __('articles.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $article->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $article->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-md-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $article->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $article->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
        </div>

        <div class="border-item photos col-md-12 other_image_container">
            <div class="row">
                <?php if($article ?? false): ?>
                    <?php $__currentLoopData = $article['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="items">
                                <div class="img">
                                    <a href="<?php echo e(asset($photo->image ?? '')); ?>" data-fancybox="gallery"><img src="<?php echo e(asset($photo->image ?? '')); ?>" alt=""></a>
                                </div>
                                <input type="hidden" name="images[]" value="<?php echo e($photo->image ?? ""); ?>">
                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <div class="text-center">
                <input id="other_image_thumbnail" class="other_image_thumbnail" type="hidden"/>
                <div class="clearfix"></div>
                <span id="add">
                    <a id="lfm" data-width="" data-cache="article_gallery" data-input=".other_image_thumbnail" data-preview="" data-show="" data-hide="" class="lfm add">
                        Add New Item
                    </a>
                </span>
            </div>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>

    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/articles.js')); ?>"></script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\cms\resources\views/admin/articles/form.blade.php ENDPATH**/ ?>