<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed id
 * @mixin Builder
 */
class Banner extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'category_id',
        'image',
    ];


    /**
     * @param null $category_id
     * @return Banner[]|\Illuminate\Database\Eloquent\Collection
     */
    public static function withDescription($category_id = null)
    {
        $query = self::join('banner_descriptions as bannerDesc', 'bannerDesc.banner_id', 'banners.id')
            ->where('bannerDesc.language_id', currentLanguage()->id);

        if ($category_id){
            $query->where('banners.category_id', $category_id);
        }

        $query->select(['banners.*', 'bannerDesc.title', 'bannerDesc.description']);

        return $query->get();
    }

}
