<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed doctor_ids
 * @mixin Builder
 */
class Conference extends Model
{
    use SoftDeletes;

    protected $fillable = ['start_date', 'end_date', 'image', 'files'];

    protected $casts = [
        'files' => 'array'
    ];


    public function careers()
    {
        return $this->hasMany(Career::class);
    }

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(ConferenceDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(ConferenceDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function withDescription($ids = [], $limit = null, $skip = null)
    {
        $query = self::orderByDesc('conferences.id')
            ->join('conference_descriptions as sDesc', 'sDesc.conference_id', 'conferences.id')
            ->where('sDesc.language_id', currentLanguage()->id);


        if (count($ids)) {
            $query->whereIn('conferences.id', $ids);
        }

        if ($limit){
            $query->limit($limit);
        }

        if ($skip){
            $query->skip($skip);
        }

        $query->select(['conferences.*', 'sDesc.description', 'sDesc.title']);

        return count($ids) == 1 ? $query->first() : $query->get();
    }


}
