<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Doctor
 * @package App
 * @mixin Builder
 */
class Doctor extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'show_in_chairman',
        'show_in_home',
        'show_in_offers',
        'category_id',
        'discount_percentage',
        'image',
        'facebook',
        'twitter',
        'instagram',
        'linkedin',
        'okadoc_url',
    ];

    public static function withDescription($ids = [], $showInChairman = false, $showInHome = false, $showInOffers = false, $category_id = null)
    {
        $query = self::join('doctor_descriptions as doctorDesc', 'doctorDesc.doctor_id', 'doctors.id')
            ->where('doctorDesc.language_id', currentLanguage()->id);
        if (count($ids)){
            $query->whereIn('doctors.id', $ids);
        }

        if ($showInChairman){
            $query->where('doctors.show_in_chairman', 1);
        }
        if ($showInHome){
            $query->where('doctors.show_in_home', 1);
        }
        if ($showInOffers){
            $query->where('doctors.show_in_offers', 1);
        }
        if ($category_id){
            $query->where('doctors.category_id', $category_id)
            ->where('doctors.show_in_offers', 1);
        }
        $query->select(['doctorDesc.*', 'doctors.*']);

        return $query->get();
    }

}
