<?php

namespace App\Http\Controllers\Web;

use App\Banner;
use App\Doctor;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;


class BannerController extends Controller
{
    private $view = 'web.banners.';

    /**
     * Show the application dashboard.
     * @param Request $request
     * @return View
     */
    public function index(Request $request): View
    {
        $title = __('banners.offers');
        $langId = currentLanguage()->id;
        $banner = Banner::withDescription(($request->category_id ?? 1))->first();
        $doctors = Doctor::withDescription([], null, null,null,($request->category_id ?? 1));
        if ($request->ajax() && $request->category_id){
            $category_id = $request->category_id;
            return view($this->view.'get_offers', get_defined_vars());
        }
        return view($this->view.'index', get_defined_vars());
    }

}
