<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;

class CheckWebSiteEnabled
{
    /**
     * Handle an incoming request.
     * Redirect user to home page if he has not the privilege to make the next action
     * @param  Request  $request
     * @param Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        Config::set('app.name', settings('website_name_'.getCurrentLocale()));
        if(settings('website_disable')){
            return abort(404);
        }
        return $next($request);
    }
}
