<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Review extends Model
{
    use SoftDeletes;

    protected $fillable = ['rate', 'image'];

    public static function withDescription()
    {
        $query = self::orderBy('reviews.id', 'DESC')
            ->join('review_descriptions as rDesc', 'rDesc.review_id', 'reviews.id')
            ->where('rDesc.language_id', currentLanguage()->id)
            ->select(['reviews.created_at', 'rDesc.*']);

        $query->select([
            'reviews.rate',
            'reviews.image',
            'rDesc.name',
            'rDesc.job_title',
            'rDesc.review',
        ]);

        return $query->cursor();
    }

}
