@extends('admin.layouts.container')

@section('content')
<form>
<div class="side-title">
    <div class="row">
        <div class="col-lg-6">
            <h3>{{ $title }}</h3>
        </div>
        <div class="col-lg-6 valign">
            <div class="edit-buttons text-right w-100">
                <a href="{{ route ('careerApplications.destroyAll') }}" data-method="delete" class="butn statusButns status_1 tableAction btn disabled bg-warning"> <span>{{ __('dashboard.sendToTrash') }}</span></a>
                <a href="#" class="butn statusButns status_1 showArchive bg-primary"> <span> {{ __('dashboard.displayTrash') }} </span></a>

                <a href="{{ route ('careerApplications.destroyAll') }}" data-method="delete" class="butn statusButns status_0 tableAction btn disabled bg-danger force"> <span> {{ __('dashboard.delete') }} </span></a>
                <a href="{{ route ('careerApplications.restoreAll') }}" data-method="put" class="butn statusButns status_0 tableAction btn disabled bg-info"> <span> {{ __('dashboard.restore') }} </span></a>
                <a href="#" class="butn statusButns status_0 showActive bg-primary"> <span> {{ __('dashboard.displayActive') }} </span></a>
            </div>
        </div>
    </div>
</div>

<!-- ------------ data table ------------- -->
<table class="table table-hover table-bordered">
    <thead>
        <tr>
            <th scope="col">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" id="selectall" name="example1">
                    <label class="custom-control-label" for="selectall"> </label>
                </div>
            </th>
            <th scope="col">{{ __('careerApplications.name') }}</th>
            <th scope="col">{{ __('careerApplications.career_id') }}</th>
            <th scope="col">{{ __('careerApplications.service_id') }}</th>
{{--            <th scope="col">{{ __('careerApplications.submission_date') }}</th>--}}
            <th scope="col" colspan="2">{{ __('careerApplications.submission_date') }}</th>
            <th scope="col">{{ __('dashboard.processes') }}</th>
        </tr>
    </thead>

    <tbody class="response">
        <tr class="search_filter_form">
            <th scope="row"></th>
            <th scope="row">
                <input type="text" name="name" value="{{ $request->name ?? '' }}" class="form-control" placeholder="">
            </th>
            <th scope="row">
                <select name="career_id" class="form-control">
                    <option value="">{{__('careerApplications.career_id')}}</option>
                    @if(count($careers))
                        @foreach($careers as $career)
                            <option value="{{$career->id}}">{{$career->currentDescription->name}}</option>
                        @endforeach
                    @endif
                </select>
            </th>

            <th scope="row">
                <select name="service_id" class="form-control">
                    <option value="">{{__('careerApplications.service_id')}}</option>
                    @if(count($services))
                        @foreach($services as $service)
                            <option value="{{$service->id}}">{{$service->currentDescription->name}}</option>
                        @endforeach
                    @endif
                </select>
            </th>
{{--            <td>--}}
{{--                <input type="date" placeholder="{{ __('careerApplications.submission_date') }}" name="submission_date" value="{{ $request->submission_date ?? '' }}" class="form-control">--}}
{{--            </td>--}}
            <td>
                <input type="date" placeholder="{{ __('dashboard.date_from') }}" name="submission_date_from" value="{{ $request->submission_date_from ?? '' }}" class=" form-control">
            </td>
            <td>
                <input type="date" placeholder="{{ __('dashboard.date_to') }}" name="submission_date_to" value="{{ $request->submission_date_to ?? '' }}" class=" form-control">
            </td>
            <th scope="col"><button type="button" class="butn color small search"><span><i class="fas fa-search"></i></span></button></th>
        </tr>
    </tbody>


</table>
<!-- ------------ sidemenu links ------------- -->
</form>
@endsection



<script>
/**
 * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
 */
var dataTable={
    route: '{{ route("careerApplications.grid") }}'
}
</script>
@section('inner_js')

@endsection
