@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_doctor_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($doctor ?? ''  && $doctor->id)
            @method('PUT')
        @endif
        @csrf

            <div class="col-md-4">
                <label>{{ meta('show_in_chairman', $lang) ?? __('doctors.show_in_chairman') }} </label>
                <select name="show_in_chairman" class="form-control">
                    <option {{($doctor->show_in_chairman ?? null) == 1 ? 'selected' : ''}} value="1">{{__('doctors.yes')}}</option>
                    <option {{($doctor->show_in_chairman ?? null) == '0' ? 'selected' : ''}} value="0">{{__('doctors.no')}}</option>
                </select>
            </div>
            <div class="col-md-4">
                <label>{{ meta('show_in_home', $lang) ?? __('doctors.show_in_home') }} </label>
                <select name="show_in_home" class="form-control">
                    <option {{($doctor->show_in_home ?? null) == 1 ? 'selected' : ''}} value="1">{{__('doctors.yes')}}</option>
                    <option {{($doctor->show_in_home ?? null) == '0' ? 'selected' : ''}} value="0">{{__('doctors.no')}}</option>
                </select>
            </div>
            <div class="col-md-4">
                <label>{{ meta('show_in_offers', $lang) ?? __('doctors.show_in_offers') }} </label>
                <select name="show_in_offers" class="form-control">
                    <option {{($doctor->show_in_offers ?? null) == 1 ? 'selected' : ''}} value="1">{{__('doctors.yes')}}</option>
                    <option {{($doctor->show_in_offers ?? null) == '0' ? 'selected' : ''}} value="0">{{__('doctors.no')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-6 {{($doctor->discount_percentage ?? null) ? '' : 'd-none'}} category_container">
                <label>{{ meta('category_id', $lang) ?? __('doctors.category_id') }} </label>
                <select name="category_id" class="form-control">
                    <option value="">{{ meta('category_id', $lang) ?? __('doctors.category_id') }}</option>
                    <option {{($doctor->category_id ?? null) == 1 ? 'selected' : ''}} value="1">{{__('doctors.category_1')}}</option>
                    <option {{($doctor->category_id ?? null) == 2 ? 'selected' : ''}} value="2">{{__('doctors.category_2')}}</option>
                    <option {{($doctor->category_id ?? null) == 3 ? 'selected' : ''}} value="3">{{__('doctors.category_3')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-6 {{($doctor->discount_percentage ?? null) ? '' : 'd-none'}} discount_percentage_container">
                <label>{{ meta('discount_percentage', $lang) ?? __('doctors.discount_percentage') }} </label>
                <input type="text" class="form-control {{ $errors->has('discount_percentage') ? 'is-invalid' : '' }}" name="discount_percentage" placeholder="{{ meta('discount_percentage', $lang) ?? __('doctors.discount_percentage') }}" value='{{ old("discount_percentage", $doctor->discount_percentage ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('facebook', $lang) ?? __('doctors.facebook') }} </label>
                <input type="url" class="form-control {{ $errors->has('facebook') ? 'is-invalid' : '' }}" name="facebook" placeholder="{{ meta('facebook', $lang) ?? __('doctors.facebook') }}" value='{{ old("facebook", $doctor->facebook ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('twitter', $lang) ?? __('doctors.twitter') }} </label>
                <input type="url" class="form-control {{ $errors->has('twitter') ? 'is-invalid' : '' }}" name="twitter" placeholder="{{ meta('twitter', $lang) ?? __('doctors.twitter') }}" value='{{ old("twitter", $doctor->twitter ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('instagram', $lang) ?? __('doctors.instagram') }} </label>
                <input type="url" class="form-control {{ $errors->has('instagram') ? 'is-invalid' : '' }}" name="instagram" placeholder="{{ meta('instagram', $lang) ?? __('doctors.instagram') }}" value='{{ old("instagram", $doctor->instagram ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('linkedin', $lang) ?? __('doctors.linkedin') }} </label>
                <input type="url" class="form-control {{ $errors->has('linkedin') ? 'is-invalid' : '' }}" name="linkedin" placeholder="{{ meta('linkedin', $lang) ?? __('doctors.linkedin') }}" value='{{ old("linkedin", $doctor->linkedin ?? "") }}'/>
            </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('okadoc_url', $lang) ?? __('doctors.okadoc_url') }} </label>
                <input type="url" class="form-control {{ $errors->has('okadoc_url') ? 'is-invalid' : '' }}" name="okadoc_url" placeholder="{{ meta('okadoc_url', $lang) ?? __('doctors.okadoc_url') }}" value='{{ old("okadoc_url", $doctor->okadoc_url ?? "") }}'/>
            </div>


            @foreach(languages() as $language)
                <div class="form-group col-lg-12">
                    <label>{{ meta('name', $language->local) ?? __('doctors.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('doctors.name') }}" value='{{ old("name_{$language->local}", $doctor[$language->local]->name ?? "") }}'/>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('specialist', $language->local) ?? __('doctors.specialist')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="specialist_{{ $language->local }}" class="form-control {{ $errors->has('specialist_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('specialist', $language->local) ?? __('doctors.specialist')}}">{{ old("specialist_{$language->local}", $doctor[$language->local]->specialist ?? "") }}</textarea>
                </div>
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('certifications', $language->local) ?? __('doctors.certifications')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="certifications_{{ $language->local }}" class="form-control {{ $errors->has('certifications_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('certifications', $language->local) ?? __('doctors.certifications')}}">{{ old("certifications_{$language->local}", $doctor[$language->local]->certifications ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('trainings', $language->local) ?? __('doctors.trainings')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="trainings_{{ $language->local }}" class="form-control {{ $errors->has('trainings_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('trainings', $language->local) ?? __('doctors.trainings')}}">{{ old("trainings_{$language->local}", $doctor[$language->local]->trainings ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('experiences', $language->local) ?? __('doctors.experiences')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="experiences_{{ $language->local }}" class="form-control {{ $errors->has('experiences_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('experiences', $language->local) ?? __('doctors.experiences')}}">{{ old("experiences_{$language->local}", $doctor[$language->local]->experiences ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('researches', $language->local) ?? __('doctors.researches')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="researches_{{ $language->local }}" class="form-control {{ $errors->has('researches_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('researches', $language->local) ?? __('doctors.researches')}}">{{ old("researches_{$language->local}", $doctor[$language->local]->researches ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('professional_memberships', $language->local) ?? __('doctors.professional_memberships')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="professional_memberships_{{ $language->local }}" class="form-control {{ $errors->has('professional_memberships_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('professional_memberships', $language->local) ?? __('doctors.professional_memberships')}}">{{ old("professional_memberships_{$language->local}", $doctor[$language->local]->professional_memberships ?? "") }}</textarea>--}}
{{--                </div>--}}
                <div class="form-group col-lg-12">
                    <label>{{ meta('details', $language->local) ?? __('doctors.details')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" id="details_{{ $language->local }}" name="details_{{ $language->local }}" class="form-control my-editor {{ $errors->has('details_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('details', $language->local) ?? __('doctors.details')}}">{{ old("details_{$language->local}", $doctor[$language->local]->details ?? "") }}</textarea>
                </div>
            @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('doctors.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $doctor->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $doctor->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $doctor->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $doctor->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_doctor_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_doctor_button', '.add_doctor_form');

        let selectedOption = $('select[name="show_in_offers"] option:selected').val();

        if(selectedOption === '1'){
            $('.category_container, .discount_percentage_container').removeClass('d-none');
        }
        if(selectedOption === '0'){
            $('.category_container, .discount_percentage_container').addClass('d-none');
            $('input[name="category_id"], input[name="discount_percentage"]').val(null);
        }


        $('select[name="show_in_offers"]').change(function () {
            let thisVal = $(this).val();
            if(thisVal === '1'){
                $('.category_container, .discount_percentage_container').removeClass('d-none');
            }

            if(thisVal === '0'){
                $('.category_container, .discount_percentage_container').addClass('d-none');
                $('select[name="category_id"], input[name="discount_percentage"]').val(null);
            }
        })
    </script>

@endsection



