@extends('admin.layouts.layout')

@section('container_content')

<div class="login section-padding">
    <div class="container">
        <div class="border-item">
            <div class="row no-gutters justify-content-center">
                <div class="col-lg-7">
                    <form method="POST" action="{{ route('admin_login') }}">
                        <div class="form_logo">
                            <img src="{{ asset($logo ?? 'assets/admin/images/logo.png') }}" alt="">
                        </div>
                        @csrf
                        <!--<div class="form-head text-center">-->
                        <!--    <h3>Login</h3>-->
                        <!--</div>-->
    
                        @if (session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif
    
                        <div class="form-group">
                            <label for="email" class="col-form-label text-md-right">{{__('users.email')}}</label>
    
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" placeholder="{{__('users.email')}}" value="{{ old('email') }}" required autocomplete="email" autofocus>
    
                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
    
                        <div class="form-group">
                            <label for="password" class="col-form-label text-md-right">{{__('users.password')}}</label>
    
                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" placeholder="{{__('users.password')}}" required autocomplete="current-password">
    
                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
    
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
    
                                    <label class="form-check-label" for="remember">
                                        {{__('users.remember_me')}}
                                    </label>
                                </div>
                            </div>
                        </div>
                        <button class="butn mt-3"><span>{{__('users.login')}}</span></button>
    
                        {{--
                        <!-- <div class="col-md-6 offset-md-6"> -->
                        @if (Route::has('password.request'))
                            <a class="btn btn-link" href="{{ route('password.request') }}">
                                {{ __('Forgot Your Password?') }}
                            </a>
                        @endif
                         --}}
                        <!-- </div> -->
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>

<!--End-Contents-->
@endsection
