@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? ''}}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="{{auth()->id()}}">
        @if($slider ?? ''  && $slider->id)
            @method('PUT')
        @endif
        @csrf

        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('title', $language->local) ?? __('sliders.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('sliders.title') }}" value='{{ old("title_{$language->local}", $slider[$language->local]->title ?? "") }}'/>
        </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('description', $language->local) ?? __('sliders.description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea rows="5" name="description_{{ $language->local }}" class="form-control {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('sliders.description')}}">{{ old("description_{$language->local}", $slider[$language->local]->description ?? "") }}</textarea>
            </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <script>
        sendAjax('.add_button', '.add_form')
    </script>
@endsection



