@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($video ?? ''  && $video->id ?? '')
            @method('PUT')
        @endif
        @CSRF

        <div class="form-group col-lg-12">
            <label>{{  meta('video_category_id', getCurrentLocale()) ?? __('videos.category') }} </label>
            <select name="video_category_id" id="video_category_id" class="form-control {{ $errors->has('video_category_id') ? 'is-invalid' : '' }}">
                <option value="">{{ meta('video_category_id', getCurrentLocale()) ?? __('videos.category') }}</option>
                @foreach (videoCategories() as $videoCategory)
                <option {{old("video_category_id", $video->video_category_id ?? "") == $videoCategory->id ? 'selected': ''}} value="{{$videoCategory->id}}">{{descriptions($videoCategory)->name ?? ''}}</option>
                @endforeach
            </select>
        </div>
        @foreach($languages as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('title', $language->local) ?? __('videos.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('videos.name') }}" value='{{ old("title_{$language->local}", $video[$language->local]->title ?? "") }}'/>
        </div>
        @endforeach

        {{--Start video type--}}
        <div class="form-group col-lg-12">
            <label>{{ meta('type', getCurrentLocale()) ?? __('videos.type') }} </label>
            <div class="card p-1">
                <div class="d-flex p-2">
                    <div class="col-md-6 custom-control custom-radio">
                        <input {{old('type', $video->type ?? '') == 1 ? 'checked' : 'checked'}} id="external" type="radio" class="custom-control-input external" name="type" value='1'/>
                        <label for="external" class="custom-control-label">{{ meta('external_link', getCurrentLocale()) ?? __('videos.external_link') }} </label>
                    </div>
                    <div class="col-md-6 custom-control custom-radio ">
                        <input {{old('type', $video->type ?? '') == 2 ? 'checked' : ''}} id="local" type="radio" class="custom-control-input local" name="type" value='2'/>
                        <label for="local" class="custom-control-label">{{ meta('local_link', getCurrentLocale()) ?? __('videos.local_link') }} </label>
                    </div>
                </div>
            </div>
        </div>
        {{--End video type--}}

        {{--Start video url--}}
        <div class="form-group col-lg-12 url_container  d-none">
            <label>{{ meta('video_url', getCurrentLocale()) ?? __('videos.url') }}</label>
            <input type="text" class="form-control url {{ $errors->has('video_url') ? 'is-invalid' : '' }}" name="video_url" placeholder="{{ meta('video_url', getCurrentLocale()) ?? __('videos.url') }}" value='{{ old("video_url", $video->video ?? "") }}'/>
        </div>
        {{--End video url--}}

        {{--Start video container--}}
        <div class="form-group col-lg-12 video_container d-none">
            <label>{{ meta('video', getCurrentLocale()) ?? __('videos.video') }} </label>
            <input id="video_thumbnail" class="video_thumbnail" type="hidden" name="video" value="{{old("video", $video->video ?? "")}}"/>

            <div class="photos main_video {{ old('video', $video->video ?? '') ? '' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div>
                            <a href="{{asset(old('video', $video->video ?? ''))}}" class="btn btn-primary video_href" target="_blank" > Browse </a>

                            <a id="lfm" data-input=".video_thumbnail" data-href=".video_href" data-preview=".video_holder" data-show=".main_video" data-hide=".pick_video_button" class="lfm btn btn-primary ml-4 text-light">
                                <i class="fas fa-video"></i> Choose
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".video_thumbnail" data-hide=".main_video" data-show=".pick_video_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_video_button {{ old('video', $video->video ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".video_thumbnail" data-href=".video_href" data-preview=".video_holder" data-show=".main_video" data-hide=".pick_video_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-video"></i> Choose
                </a>
            </span>

        </div>
        {{--End video container--}}

        {{--Start image container--}}
        @if (preg_match('/https:\/\/img\.youtube\.com/', $video->image ?? '', $match) )

            <div class="form-group col-lg-12 youtube_thumbnails">
                <label>{{ meta('image', getCurrentLocale()) ?? __('videos.image') }} </label>
                <div class="photos {{ $video->image ?? '' ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-4">
                        <div class="items">
                            <div class="img">
                                <a target="_blank" href="{{$video->image ?? ''}}" >
                                    <img src="{{$video->image ?? ''}}">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        <div class="form-group col-lg-12 image_container d-none">
            <label>{{ meta('image', getCurrentLocale()) ?? __('videos.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $video->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $video->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('image', $video->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $video->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
{{--    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>--}}
        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/videos.js') }}"></script>
@endsection
