@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($workHour ?? ''  && $workHour->id)
            @method('PUT')
        @endif
        @csrf

            <div class="form-group col-lg-3">
                <label>{{ meta('week_day', $lang) ?? __('workHours.week_day') }} </label>
                <select name="week_day" class="form-control {{ $errors->has('week_day') ? 'is-invalid' : '' }}">
                    @if(count($weekDays))
                        @foreach($weekDays as $key => $weekDay)
                            <option {{old('week_day', $workHour->week_day ?? null) == $key ? 'selected' : '' }} value="{{$key}}">{{$weekDay}}</option>
                        @endforeach
                    @endif
                </select>
            </div>

            <div class="form-group col-lg-3">
                <label>{{ meta('status', $lang) ?? __('workHours.status') }} </label>
                <select name="status" class="form-control {{ $errors->has('status') ? 'is-invalid' : '' }}">
                    <option {{old('status', $workHour->status ?? null) == 'open' ? 'selected' : '' }} value="open">{{__('workHours.open')}}</option>
                    <option {{old('status', $workHour->status ?? null) == 'closed' ? 'selected' : '' }} value="closed">{{__('workHours.closed')}}</option>
                </select>
            </div>

            <div class="form-group col-lg-3 input_time {{($workHour->status ?? null) == 'closed' ? 'd-none' : ''}}">
                <label>{{ meta('time_from', $lang) ?? __('workHours.name') }}</label>
                <input type="time" class="form-control {{ $errors->has('time_from') ? 'is-invalid' : '' }}" name="time_from" placeholder="{{ meta('time_from', $lang) ?? __('workHours.time_from') }}" value='{{ old("time_from", $workHour->time_from ?? "") }}'/>
            </div>
            <div class="form-group col-lg-3 input_time {{($workHour->status ?? null) == 'closed' ? 'd-none' : ''}}">
                <label>{{ meta('time_to', $lang) ?? __('workHours.name') }}</label>
                <input type="time" class="form-control {{ $errors->has('time_to') ? 'is-invalid' : '' }}" name="time_to" placeholder="{{ meta('time_to', $lang) ?? __('workHours.time_to') }}" value='{{ old("time_to", $workHour->time_to ?? "") }}'/>
            </div>

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <script>
        sendAjax('.add_button', '.add_form');

        $('select[name="status"]').change(function () {
            if($(this).val() === 'closed'){
                $('input[type="time"]').val('');
                $('.input_time').addClass('d-none');
            }
            if($(this).val() === 'open'){
                $('.input_time').removeClass('d-none');
            }
        })
    </script>

@endsection



