@extends('admin.layouts.container')

@section('content')
<form>
<div class="side-title">
    <div class="row">
        <div class="col-lg-6">
            <h3>{{ $title }}</h3>
        </div>
    </div>
</div>

<!-- ------------ data table ------------- -->
<table class="table table-hover table-bordered">
    <thead>
        <tr>
            <th scope="col">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" id="selectall" name="example1">
                    <label class="custom-control-label" for="selectall"> </label>
                </div>
            </th>
            <th scope="col">{{ __('workHours.week_day') }}</th>
            <th scope="col">{{ __('workHours.time_from') }}</th>
            <th scope="col">{{ __('workHours.time_to') }}</th>
            <th scope="col" colspan="2">{{ __('dashboard.created_at') }}</th>
            <th scope="col">{{ __('dashboard.processes') }}</th>
        </tr>
    </thead>

    <tbody class="response">
        <tr class="search_filter_form">
            <th scope="row"></th>
            <th scope="row">
                <select name="week_day" class="form-control">
                    <option value="">{{__('workHours.week_day')}}</option>
                    @if(count($weekDays))
                        @foreach($weekDays as $key => $weekDay)
                            <option value="{{strtolower($key)}}">{{$weekDay}}</option>
                        @endforeach
                    @endif
                </select>
            </th>
            <th scope="row">
                <input type="time" name="time_from" value="{{ $request->time_from ?? '' }}" class="form-control" placeholder="{{__('workHours.time_from')}}">
            </th>
            <th scope="row">
                <input type="time" name="time_to" value="{{ $request->time_to ?? '' }}" class="form-control" placeholder="{{__('workHours.time_to')}}">
            </th>

            <td>
                <input type="date" placeholder="{{ __('dashboard.date_from') }}" name="date_from" value="{{ $request->date_from ?? '' }}" class=" form-control">
            </td>
            <td>
                <input type="date" placeholder="{{ __('dashboard.date_to') }}" name="date_to" value="{{ $request->date_to ?? '' }}" class=" form-control">
            </td>
            <th scope="col"><button type="button" class="butn color small search"><span><i class="fas fa-search"></i></span></button></th>
        </tr>
    </tbody>


</table>
<!-- ------------ sidemenu links ------------- -->
</form>
@endsection



<script>
/**
 * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
 */
var dataTable={
    route: '{{ route("workHours.grid") }}'
}
</script>
@section('inner_js')

@endsection
