@extends('web.layouts.container')

@section('content')
    <div class="summus-section-banner">
        <div id="okadoc-content"></div>
    </div>
@endsection

@section('inner_js')
    <script>
        // $('.summus-section-banner').append(`<div id="okadoc-content"></div>`);
        let metaExist = $('meta[name="viewport"]');

        if(!metaExist.length){
            $('head').append(`<meta name="viewport" content="width=device-width, initial-scale=1, maximumscale=1"/>`);
        }

        let local = "{{getCurrentLocale()}}";
        var okaWidgetOption = okaWidgetOption || {
            heading1: "Book an Appointment",
            heading2: "Book an appointment now",
            url: "https://priory.okadoc.com/"+local+"-sa",
            selector: "okadoc-content",
            target: "_top",
            targetUrl: "https://priory.okadoc.com/"+local+"-sa/search/result",
            clientKey: "whitelabel-priory",
            template: "gamma",
        };
        (function() {
            var oka = document.createElement("script");
            oka.type = "text/javascript";
            oka.async = true;
            oka.src = ("https:" == document.location.protocol ? "https://" :
                "http://") + 'priory.okadoc.com/static/js/embed.js';
            var s = document.getElementsByTagName("script")[0];
            s.parentNode.insertBefore(oka, s);
        })();
    </script>
@endsection
