@extends('web.layouts.container')

@section('content')
    <section class="doctors-pg section bg-babyBlue">
        <div class="container">
            <h2 class="title text-center fw-bold color-dark mb-5 text-capitalize">{{$pageTitle1}} <span class="color-primary">{{$pageTitle2}}</span></h2>
            <div class="row">
                @if(count($doctors))
                    @foreach($doctors as $doctor)
                <div class="col-lg-3 col-md-6">
                    <div class="dr_card wow fadeInUp">
                        <div class="img-box">
                            <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                        </div>
                        <div class="card-body">
                            <h4 class="name mb-3">{{$doctor->name}}</h4>
                            <p class="job">{{$doctor->specialist}}</p>
                            @if($doctor->okadoc_url)
                                <a target="_blank" href="{{$doctor->okadoc_url}}" class="butn primary_butn">{{__('main.make_appointment')}}</a>
                            @endif
                        </div>
                        <span class="v_shap"></span>
                        <span class="h_shap"></span>
                    </div>
                </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <section class="call_box">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="info">
                        <span class="icon">
                            <img src="{{asset('assets/web/images/call.png')}}" alt="">
                        </span>
                        <div class="inf">
                            <p class=""> {{__('main.call_to_action')}} </p>
                            <h2> {{$settings['site_phone']}} </h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-lg-center mt-5 mt-lg-0">
                    <a href="{{$settings['booking_appointment_url']}}" class="butn text-uppercase">{{__('main.make_appointment')}}</a>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
